# Fragments Vault

Capture fragments, quotes, and ideas found while reading.

## Voice

This vault is for storage, not content creation. No voice guidelines needed.

---

## Folder Structure

```
fragments/
├── CLAUDE.md        # This file (structure + tags registry)
├── inbox.md         # Unprocessed fragments (capture here)
├── career.md        # Work, money, negotiation, employers
├── building.md      # Side projects, indie hacking, startups
└── life.md          # Philosophy, values, relationships, decisions
```

---

## Fragment Format

Each fragment follows this structure:

```markdown
---
> "The fragment or quote here"

**Source**: Author, Platform/Book
**Tags**: #tag1 #tag2 #tag3
**Why**: Why this resonated with you
**Date**: YYYY-MM-DD

---
```

---

## Tags Registry

Keep this list updated to avoid duplicates. When adding a new tag, add it here first.

### Career

#salary #negotiation #employers #value #leverage #job-search #promotion #skills #expertise

### Building

#side-projects #indie #startup #shipping #mvp #build-in-public #product #growth #monetization

### Life

#honesty #values #relationships #decisions #freedom #minimalism #time #priorities #focus

---

## Skills

| Skill                 | Purpose                                    |
| --------------------- | ------------------------------------------ |
| `/save-fragment`      | Quick capture to inbox.md                  |
| `/organize-fragments` | Process inbox, categorize, move to library |
| `/browse-fragments`   | Search and explore fragments               |

---

## Workflow

1. **Capture** → `/save-fragment` adds to `inbox.md`
2. **Organize** → `/organize-fragments` categorizes and moves to the right file
3. **Use** → `/browse-fragments` to find inspiration when needed
